#!/usr/bin/env python
# Remove dependencies
# Copyright 2004 by Brian C. Christensen

#    This file is part of GanttPV.
#
#    GanttPV is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    GanttPV is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with GanttPV; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

# 050504 - first version of this script

# This doesn't remove all dependencies, only dependencies between selected tasks

def hint(s):
    try:
        Data.Hint("%s: %s" % (scriptname, s))
    except AttributeError:
        self.SetStatusText(s)

def DoRemoveDependencies(self):
        if debug: print " Start Remove Dependencies"

        # find the selected rows
        sel = self.Report.GetSelectedRows()  # current selection
        if len(sel) <= 1:
            hint("Must select at least two tasks.")
            return

        # is this a task report
        r = Data.Report[self.ReportID]
        if not r.has_key('ReportTypeID') or not Data.ReportType.has_key(r['ReportTypeID']): 
            if debug: print "ReportType key not found"
            return
        rt = Data.ReportType[r['ReportTypeID']]
        ta = rt.get('TableA')
        # tb = rt.get('TableB')  # if two table report all inserts go at the end (less confusing to user)
        if ta != 'Task':
            hint("Use only on Task reports.")
            return  # only on task reports

        rows = self.Report.table.rows
        tids = [ Data.ReportRow[rows[x]].get('TableID') for x in sel if Data.ReportRow[rows[x]].get('TableName') == 'Task' ]
        if len(tids) < 2:
            hint("Must select at least two tasks.")
            return

        dbd = Data.Database['Dependency']
        dids = [ x for x in dbd if dbd[x].get('PrerequisiteID') in tids and dbd[x].get('TaskID') in tids ]

        for did in dids:  # delete existing dependency records
            # look for an existing dependency record
            if Data.Database['Dependency'][did].get('zzStatus') != 'deleted':
                change = { 'Table': 'Dependency', 'ID': did, 'zzStatus': 'deleted' }
                Data.Update(change)
        Data.SetUndo("Remove Dependencies")

        if debug: print "End Remove Dependencies"

DoRemoveDependencies(self)
